// sinceclock
// oswald berthold 10/2007
// nach d. i. repetto, http://music.columbia.edu/~douglas/portfolio/sineclock/

(
Server.default = s = Server.local;
s.boot;
g = SwingOSC.default;
g.boot;
)

(
SynthDef(\sineclock2, {
	|b1(200), b2(300), b3(450), p1(0), p2(0), p3(0), a1(0.1), a2(0.08), a3(0.05)| // b: base, p: phase
	var m, m1, h, h1, d, d1;
	m = SinOsc.ar(b1, 0, a1);
	m1 = SinOsc.ar(b1 + p1, 0, a1);
	h = SinOsc.ar(b2, 0, a2);
	h1 = SinOsc.ar(b2 + p2, 0, a2);
	d = SinOsc.ar(b3, 0, a3);
	d1 = SinOsc.ar(b3 + p3, 0, a3);
	Out.ar(0, Mix([m, m1, h, h1, d, d1]));
}).send(s)
)
(
var clocksynth;
clocksynth = Synth(\sineclock2, [\b1, 200, \b2, 300, \b3, 450,
	\p1, 0, // set phase from current time
	\p2, 0, // set phase from current time
	\p3, 0, // set phase from current time
	\a1, 0.15, \a2, 0.08, \a3, 0.05]);
t = Task {
	var min, hour, day;
	var m_min, m_hour, m_day;
	var f_min, f_hour, f_day;
	inf.do {
		a = Date.getDate; // init Date/Time
		a.postln;
		min = a.format("%S").asInteger;
		hour = a.format("%M").asInteger;
		day = a.format("%H").asInteger;
		m_min = ((min - 30).abs - 30).abs;
		m_hour = (((hour * 60 + min) - 1800).abs - 1800).abs;
		m_day = (((day * 3600 + (hour * 60) + min) - 43200).abs - 43200).abs;
		f_min = m_min / 6;
		f_hour = m_hour / 360;
		f_day = m_day / 8640;
		[min, m_min, f_min, hour, m_hour, f_hour, day, m_day, f_day].postln;
		clocksynth.set(\p1, f_min);
		clocksynth.set(\p2, f_hour);
		clocksynth.set(\p3, f_day);
		1.0.wait;
	};
};
t.start;
)

t.stop;
t.reset;


// oscillator variante
// faulty
(
SynthDef(\sineclock, {
	|b1(200), b2(300), b3(450), p1(0), p2(0), p3(0), a1(0.1), a2(0.08), a3(0.05)| // b: base, p: phase
	var m, m1, h, h1, d, d1;
	m = SinOsc.ar(b1, 0, a1);
	m1 = SinOsc.ar(b1 + SinOsc.ar(120.reciprocal, p1, 5.0).abs, 0, a1);
	h = SinOsc.ar(b2, 0, a2);
	h1 = SinOsc.ar(b2 + SinOsc.ar(7200.reciprocal, p2, 5.0).abs, 0, a2);
	d = SinOsc.ar(b3, 0, a3);
	d1 = SinOsc.ar(b3 + SinOsc.ar(172800.reciprocal, p3, 5.0).abs, 0, a3);
	Out.ar(0, Mix([m, m1, h, h1, d, d1]));
}).send(s);
)


(
// instantiate Synth and create GUI for amplitude adjustment
var clocksynth; // the synth
var win, sl1, sl2, sl3; // GUI elements
var nb1, nb2, nb3;
var a1, a2, a3; // the amplitudes
a1 = 0.15;
a2 = 0.08;
a3 = 0.03;
a = Date.getDate; // init Date/Time
clocksynth = Synth(\sineclock, [\b1, 200, \b2, 300, \b3, 450,
	\p1, a.format("%H").asInteger/24 * 1, // set phase from current time
	\p2, a.format("%M").asInteger/60 * 1, // set phase from current time
	\p3, a.format("%S").asInteger/60 * 1, // set phase from current time
	\a1, a1, \a2, a2, \a3, a3]);
// create window and GUI elements
win = GUI.window.new(\SineClock, Rect(0,0,200,200));
sl1 = GUI.slider.new(win, Rect(10, 10, 200, 20));
nb1 = GUI.numberBox.new(win, Rect( 220, 10, 40, 20 ));
sl1.action = {|sl|
	clocksynth.set(\a1, sl.value);
	nb1.value = sl.value;
};
sl2 = GUI.slider.new(win, Rect(10, 40, 200, 20));
nb2 = GUI.numberBox.new(win, Rect( 220, 40, 40, 20 ));
sl2.action = {|sl|
	clocksynth.set(\a2, sl.value);
	nb2.value = sl.value;
};
sl3 = GUI.slider.new(win, Rect(10, 90, 200, 20));
nb3 = GUI.numberBox.new(win, Rect( 220, 90, 40, 20 ));
sl3.action = {|sl|
	clocksynth.set(\a3, sl.value);
	nb3.value = sl.value;
};
// init GUI elements to actual values
sl1.value = a1; nb1.value = a1; 
sl2.value = a2; nb2.value = a2;
sl3.value = a3; nb3.value = a3;
win.front;
)
